#include "AgentImplementationController.h"

AgentImplementationController::AgentImplementationController(BlockingChannelPtr dataChannel,
                                                             ContextManager *contextManager,
                                                             AgObjectPtr commandExecutionService, // Not used in parent class
                                                             int maxEventQueueLength):
        DefaultClientController(dataChannel, contextManager, commandExecutionService, maxEventQueueLength)
{

}

bool AgentImplementationController::controllerShouldHandle(EventPtr, ContextEventListener*)
{
    return true;
}

void AgentImplementationController::processMessageOperation(IncomingAggreGateCommandPtr cmd, OutgoingAggreGateCommandPtr ans)
{
    DefaultClientController::processMessageOperation(cmd, ans);

    AgString context = cmd->getParameter(AggreGateCommand::INDEX_OPERATION_CONTEXT);

    Context *con = getContext(context);

    if (con)
    {
        addNormalListener(con->getPath(), AbstractContextStrings::E_UPDATED, getDefaultEventListener());
    }
}

ClassicEncodingSettingsPtr AgentImplementationController::createClassicEncodingSettings(bool useFormatCache)
{
    ClassicEncodingSettingsPtr encodingSettings = ClassicEncodingSettingsPtr(DefaultClientController::createClassicEncodingSettings(useFormatCache));
    encodingSettings->setEncodeFormat(!useFormatCache);
    return encodingSettings;
}
