#include "AgentContextManager.h"

AgentContextManager::AgentContextManager(Context *rootContext, bool async, Agent* agent):
    DefaultContextManager(rootContext, async)
{
    controller = boost::bind(&Agent::getContextEventListener, agent);
}

void AgentContextManager::eventAdded(Context* con, EventDefinitionPtr ed)
{
    DefaultContextManager::eventAdded(con, ed);

    if (!ed->getGroup().empty() && con)
    {
        con->addEventListener(ed->getName(), controller(), true);
    }
}
