#include "ActionContext.h"
#include "AggreGateException.h"

ActionContext::ActionContext(ActionDefinitionPtr actionDefinition, ActionManagerPtr actionManager)
{
    setActionDefinition(actionDefinition);
    setActionManager(actionManager);
}

ActionDefinitionPtr ActionContext::getActionDefinition()
{
    return actionDefinition;
}

BatchContextPtr ActionContext::getBatchContext()
{
    return batchContext;
}

RequestCachePtr ActionContext::getRequestCache()
{
    return requestCache;
}

unsigned char ActionContext::getActionState()
{
	return actionState;
}

ActionManagerPtr ActionContext::getActionManager()
{
    return actionManager;
}

std::list<RequestIdentifierPtr>& ActionContext::getRequestedIds()
{
	return requestedIds;
}

void ActionContext::setActionDefinition(ActionDefinitionPtr actionDefinition)
{
	if(actionDefinition == 0)
	{
        throw AggreGateException("ActionContext::setActionDefinition() null pointer");
    }
    this->actionDefinition = actionDefinition;
}

void ActionContext::setBatchContext(BatchContextPtr batchContext)
{
    this->batchContext = batchContext;
}

void ActionContext::setRequestCache(RequestCachePtr requestCache)
{
    this->requestCache = requestCache;
}

void ActionContext::setActionState(unsigned char actionState)
{
	this->actionState = actionState;
}

void ActionContext::setActionManager(ActionManagerPtr actionManager)
{
    if (actionManager == NULL)
	{
        throw AggreGateException("ActionContext::setActionManager() null pointer");
	}
    this->actionManager = actionManager;
}







