#ifndef CGlobaVarH
#define CGlobaVarH

#include "util/simpleobject/AgString.h"
#include <map>

#define AGG_GLOBAL GlobalVars::instance()

class GlobalVars
{
public:
    static GlobalVars &instance();
private:
    GlobalVars();

public:
    std::map<AgString, char> CLASS_TO_TYPE;
    std::map<char, AgString> TYPE_SELECTION_VALUES;

    AgString ELEMENT_FLAGS;
    AgString ELEMENT_DEFAULT_VALUE;
    AgString ELEMENT_DESCRIPTION;
    AgString ELEMENT_HELP;
    AgString ELEMENT_SELECTION_VALUES;
    AgString ELEMENT_VALIDATORS;
    AgString ELEMENT_EDITOR;
    AgString ELEMENT_EDITOR_OPTIONS;
    AgString ELEMENT_ICON;
    AgString ELEMENT_GROUP;

    const char ADVANCED_FLAG;
    const char NOT_REPLICATED_FLAG;
    const char EXTENDABLE_SELECTION_VALUES_FLAG;
    const char HIDDEN_FLAG;
    const char INLINE_DATA_FLAG;
    const char KEY_FIELD_FLAG;
    const char NULLABLE_FLAG;
    const char OPTIONAL_FLAG;
    const char READ_ONLY_FLAG;
    const char DEFAULT_OVERRIDE;

    const char INTEGER_FIELD;
    const char STRING_FIELD;
    const char BOOLEAN_FIELD;
    const char LONG_FIELD;
    const char FLOAT_FIELD;
    const char DOUBLE_FIELD;
    const char DATE_FIELD;
    const char DATATABLE_FIELD;
    const char COLOR_FIELD;
    const char DATA_FIELD;

    const char VALIDATOR_LIMITS;
    const char VALIDATOR_REGEX;
    const char VALIDATOR_NON_NULL;
    const char VALIDATOR_ID;

    const int DEFAULT_QUALITY_VALUE;

    AgString EDITOR_BYTES;
    AgString EDITOR_LIST;
    AgString EDITOR_BAR;

    AgString EDITOR_SPINNER;
    AgString EDITOR_EVENT_LEVEL;
    AgString EDITOR_BOX;

    AgString SEPARATOR;
    AgString SEPARATOR_REGEX;

    AgString EDITOR_TIME;
    AgString EDITOR_DATE;

    AgString EDITOR_PERIOD;

    AgString EDITOR_CONTEXT_MASK;
    AgString EDITOR_CONTEXT;
    AgString EDITOR_EXPRESSION;
    AgString EDITOR_ACTIVATOR;
    AgString EDITOR_TARGET;
    AgString EDITOR_CODE;
    AgString EDITOR_TEXT;
    AgString EDITOR_TEXT_AREA;
    AgString EDITOR_EMBEDDED_TEXT_AREA;
    AgString EDITOR_REFERENCE;
    AgString EDITOR_PASSWORD;
    AgString EDITOR_FONT;
    AgString EDITOR_IP;
    AgString EDITOR_HTML;

    AgString FIELD_ADDITIONAL_REFERENCES_REFERENCE;
    AgString FIELD_ADDITIONAL_REFERENCES_DESCRIPTION;

    AgString FIELD_DEFAULT_TABLE;
    AgString FIELD_DEFAULT_CONTEXT;
    AgString FIELD_REFERENCES;

    AgString TEXT_EDITOR_MODE_AGGREGATE;
    AgString TEXT_EDITOR_MODE_JAVA;
    AgString TEXT_EDITOR_MODE_XML;
    AgString TEXT_EDITOR_MODE_SQL;
    AgString TEXT_EDITOR_MODE_HTML;
    AgString TEXT_EDITOR_MODE_SHELLSCRIPT;
    AgString TEXT_EDITOR_MODE_SMI_MIB;

    AgString CODE_EDITOR_MODE_JAVA;

    AgString EDITOR_TARGET_MODE_MODELS;

    AgString CONTEXT_EDITOR_TYPES_SEPARATOR;
    TableFormatPtr EXPRESSION_BUILDER_OPTIONS_FORMAT;
    TableFormatPtr ADDITIONAL_REFERENCES_FORMAT;

    AgString FIELD_NAME;
    AgString FIELD_EXPRESSION;

    AgString EDITOR_IMAGE;
    AgString EDITOR_SOUND;
    AgString EDITOR_HEX;

};




#endif 
