#include "GlobalVars.h"
#include "Cres.h"
#include "util/simpleobject/AgInteger.h"
#include "util/simpleobject/AgBoolean.h"
#include "util/simpleobject/AgLong.h"
#include "util/simpleobject/AgFloat.h"
#include "util/simpleobject/AgDouble.h"
#include "util/simpleobject/AgDate.h"
#include "util/simpleobject/AgColor.h"
#include "data/Data.h"
#include "datatable/DataTable.h"

GlobalVars &GlobalVars::instance()
{
    static GlobalVars globalVars;
    return globalVars;
}

GlobalVars::GlobalVars() :
    ADVANCED_FLAG('A'),
    NOT_REPLICATED_FLAG('C'),
    EXTENDABLE_SELECTION_VALUES_FLAG('E'),
    HIDDEN_FLAG('H'),
    INLINE_DATA_FLAG('I'),
    KEY_FIELD_FLAG('K'),
    NULLABLE_FLAG('N'),
    OPTIONAL_FLAG('O'),
    READ_ONLY_FLAG('R'),
    DEFAULT_OVERRIDE('D'),

    INTEGER_FIELD('I'),
    STRING_FIELD('S'),
    BOOLEAN_FIELD('B'),
    LONG_FIELD('L'),
    FLOAT_FIELD('F'),
    DOUBLE_FIELD('E'),
    DATE_FIELD('D'),
    DATATABLE_FIELD('T'),
    COLOR_FIELD('C'),
    DATA_FIELD('A'),

    VALIDATOR_LIMITS('L'),
    VALIDATOR_REGEX('R'),
    VALIDATOR_NON_NULL('N'),
    VALIDATOR_ID('I'),

    DEFAULT_QUALITY_VALUE(192)
{
    ELEMENT_FLAGS = "F";
    ELEMENT_DEFAULT_VALUE = "A";
    ELEMENT_DESCRIPTION = "D";
    ELEMENT_HELP = "H";
    ELEMENT_SELECTION_VALUES = "S";
    ELEMENT_VALIDATORS = "V";
    ELEMENT_EDITOR = "E";
    ELEMENT_EDITOR_OPTIONS = "O";
    ELEMENT_ICON = "I";
    ELEMENT_GROUP = "G";

    EDITOR_BYTES = "list";
    EDITOR_LIST = "bar";
    EDITOR_BAR = "bytes";

    CLASS_TO_TYPE[typeid(AgInteger).name()] = INTEGER_FIELD;
    CLASS_TO_TYPE[typeid(AgString).name()] = STRING_FIELD;
    CLASS_TO_TYPE[typeid(AgBoolean).name()] = BOOLEAN_FIELD;
    CLASS_TO_TYPE[typeid(AgLong).name()] = LONG_FIELD;
    CLASS_TO_TYPE[typeid(AgFloat).name()] = FLOAT_FIELD;
    CLASS_TO_TYPE[typeid(AgDouble).name()] = DOUBLE_FIELD;
    CLASS_TO_TYPE[typeid(AgDate).name()] = DATE_FIELD;
    CLASS_TO_TYPE[typeid(DataTable).name()] = DATATABLE_FIELD;
    CLASS_TO_TYPE[typeid(AgColor).name()] = COLOR_FIELD;
    CLASS_TO_TYPE[typeid(Data).name()] = DATA_FIELD;

    TYPE_SELECTION_VALUES[INTEGER_FIELD] = Cres::get()->getString("dtInteger");
    TYPE_SELECTION_VALUES[STRING_FIELD] = Cres::get()->getString("dtString");
    TYPE_SELECTION_VALUES[BOOLEAN_FIELD] = Cres::get()->getString("dtBoolean");
    TYPE_SELECTION_VALUES[LONG_FIELD] = Cres::get()->getString("dtLong");
    TYPE_SELECTION_VALUES[FLOAT_FIELD] = Cres::get()->getString("dtFloat");
    TYPE_SELECTION_VALUES[DOUBLE_FIELD] = Cres::get()->getString("dtDouble");
    TYPE_SELECTION_VALUES[DATE_FIELD] = Cres::get()->getString("date");
    TYPE_SELECTION_VALUES[DATATABLE_FIELD] = Cres::get()->getString("dtDataTable");
    TYPE_SELECTION_VALUES[COLOR_FIELD] = Cres::get()->getString("color");
    TYPE_SELECTION_VALUES[DATA_FIELD] = Cres::get()->getString("dtDataBlock");

    EDITOR_SPINNER = "spinner";
    EDITOR_EVENT_LEVEL = "eventLevel";
    EDITOR_BOX = "box";

    SEPARATOR = "^^";
    SEPARATOR_REGEX = "\\^\\^";

    EDITOR_TIME = "time";
    EDITOR_DATE = "date";

    EDITOR_PERIOD = "period";

    EDITOR_CONTEXT_MASK = "contextmask";
    EDITOR_CONTEXT = "context";
    EDITOR_EXPRESSION = "expression";
    EDITOR_ACTIVATOR = "activator";
    EDITOR_TARGET = "target";
    EDITOR_CODE = "code";
    EDITOR_TEXT = "text";
    EDITOR_TEXT_AREA = "textarea";
    EDITOR_EMBEDDED_TEXT_AREA = "etextarea";
    EDITOR_REFERENCE = "reference";
    EDITOR_PASSWORD = "password";
    EDITOR_FONT = "font";
    EDITOR_IP = "ip";
    EDITOR_HTML = "html";

    CONTEXT_EDITOR_TYPES_SEPARATOR = " ";

    FIELD_ADDITIONAL_REFERENCES_REFERENCE = "reference";
    FIELD_ADDITIONAL_REFERENCES_DESCRIPTION = "description";

    FIELD_DEFAULT_TABLE = "table";
    FIELD_DEFAULT_CONTEXT = "context";
    FIELD_REFERENCES = "references";

    TEXT_EDITOR_MODE_AGGREGATE = "aggregate";
    TEXT_EDITOR_MODE_JAVA = "java";
    TEXT_EDITOR_MODE_XML = "xml";
    TEXT_EDITOR_MODE_SQL = "sql";
    TEXT_EDITOR_MODE_HTML = "html";
    TEXT_EDITOR_MODE_SHELLSCRIPT = "shellscript";
    TEXT_EDITOR_MODE_SMI_MIB = "smi-mib";

    CODE_EDITOR_MODE_JAVA = "java";

    EDITOR_TARGET_MODE_MODELS = "models";

    FIELD_NAME="name";
    FIELD_EXPRESSION = "expression";

    EDITOR_IMAGE = "image";
    EDITOR_SOUND = "sound";
    EDITOR_HEX = "hex";
}
