$(document).ready(function() {

	var hash = window.location.hash.substr(1);
	var href = $('#nav li a').each(function(){
		var href = $(this).attr('href');
		if(hash==href.substr(0,href.length-5)){
			var toLoad = hash+'.html #content';
			$('#content').load(toLoad)
		}
	});

	$('#nav li a').on('click', function(e) {
		e.preventDefault();

		const nav = document.querySelector("#nav");

		// Remove all "active" styles from all elements in the nav
		Array.from(nav.querySelectorAll('.current, .current-page')).forEach(
			(el) => {
				el.classList.remove('current', 'current-page')
				el.classList.add('normal')
			}
		);

		// Collect all parents
		let parentNode = this.parentNode;
		var parents = [];
		while (parentNode) {
			parents.unshift(parentNode);
			parentNode = parentNode.parentNode;
		}

		// Filter parents to add "active" styles
		const filteredParents = parents.filter(el => {
			return el?.matches?.("[class*='toctree-']")
		})

		filteredParents.forEach(
			(el) => {
				el.classList.remove('normal')
				el.classList.add('current', 'current-page')
			}
		);
	});

	$('#nav li a').click(function(){
		var toLoad = $(this).attr('href')+' #content';
		var hyperT = $(this).text();
		try {
			$('#content').hide('slow',loadContent);
			$('#load').remove();
			$('.article-container').append('<span id="load"><!-- LOADING... --></span>');
			$('#load').fadeIn('normal');
			document.title = hyperT;
			window.history.pushState({id:'home', source:'web'}, hyperT, $(this).attr('href').substr(0,$(this).attr('href').length));
			function loadContent() {
				console.log("kek")
				$('#content').parent().load(toLoad,'',showNewContent())
			}
			function showNewContent() {
				$('#content').show('normal',hideLoader());
			}
			function hideLoader() {
				$('#load').fadeOut('normal');
				$('#content').css("visibility","hidden");
			}
		}
		catch (e) {
			window.location.replace(
				$(this).attr('href').substr(0,$(this).attr('href').length),
			);
		}
		return false;
	});

});